#!/bin/bash

# This test can only run if netcat is present
#
if ! type nc >/dev/null; then exit; fi

PORT=54325			# Some port that is unlikely to be in use

# Start 11 "servers" that redirect to each other
#
for ((i = 0; i < 11; i++)); do
  ((p = PORT + i))
  ((q = p + 1))
  echo -e "HTTP/1.1 302\r\nLocation: http://localhost:$q/\r\n\r" |\
    nc -l $p >/dev/null &
done

sleep 1				# Give the servers time to start

./hxextract body http://localhost:$PORT/ 2>&1 | grep -q 'Too many links'

code=$?

kill %1
kill %2
kill %3
kill %4
kill %5
kill %6
kill %7
kill %8
kill %9
kill %10
kill %11
wait

exit $code
