/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.commons.collections4.set;

import java.util.Set;

import org.apache.commons.collections4.map.HashedMap;

/**
 * JUnit test.
 *
 * @since 3.1
 * @version $Id: MapBackedSetTest.java 1469009 2013-04-17 17:56:22Z tn $
 */
public class MapBackedSetTest<E> extends AbstractSetTest<E> {

    public MapBackedSetTest(final String testName) {
        super(testName);
    }

    @Override
    public Set<E> makeObject() {
        return MapBackedSet.mapBackedSet(new HashedMap<E, Object>());
    }

    @Override
    public String getCompatibilityVersion() {
        return "4";
    }

//    public void testCreate() throws Exception {
//        resetEmpty();
//        writeExternalFormToDisk((java.io.Serializable) getCollection(), "src/test/resources/data/test/MapBackedSet.emptyCollection.version4.obj");
//        resetFull();
//        writeExternalFormToDisk((java.io.Serializable) getCollection(), "src/test/resources/data/test/MapBackedSet.fullCollection.version4.obj");
//    }

}
