/*
 * @(#)IReportGeneratorUTestI.java
 *
 * Copyright (C) 2002-2003 Matt Albrecht
 * groboclown@users.sourceforge.net
 * http://groboutils.sourceforge.net
 *
 *  Permission is hereby granted, free of charge, to any person obtaining a
 *  copy of this software and associated documentation files (the "Software"),
 *  to deal in the Software without restriction, including without limitation
 *  the rights to use, copy, modify, merge, publish, distribute, sublicense,
 *  and/or sell copies of the Software, and to permit persons to whom the
 *  Software is furnished to do so, subject to the following conditions:
 *
 *  The above copyright notice and this permission notice shall be included in
 *  all copies or substantial portions of the Software.
 *
 *  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 *  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 *  THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 *  FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 *  DEALINGS IN THE SOFTWARE.
 */

package net.sourceforge.groboutils.codecoverage.v2.report;

import java.io.File;
import java.io.IOException;

import net.sourceforge.groboutils.autodoc.v1.AutoDoc;
import net.sourceforge.groboutils.codecoverage.v2.CCCreatorUtil;
import net.sourceforge.groboutils.codecoverage.v2.IAnalysisModule;
import net.sourceforge.groboutils.codecoverage.v2.datastore.DirMetaDataReader;
import net.sourceforge.groboutils.codecoverage.v2.logger.DirectoryChannelLogReader;
import net.sourceforge.groboutils.junit.v1.iftc.ImplFactory;
import net.sourceforge.groboutils.junit.v1.iftc.InterfaceTestCase;
import net.sourceforge.groboutils.junit.v1.iftc.InterfaceTestSuite;

import org.w3c.dom.Element;


/**
 * Tests the IReportGenerator interface.
 *
 * @author    Matt Albrecht <a href="mailto:groboclown@users.sourceforge.net">groboclown@users.sourceforge.net</a>
 * @version   $Date: 2004/04/15 05:48:29 $
 * @since     December 28, 2002
 */
public class IReportGeneratorUTestI extends InterfaceTestCase
{
    //-------------------------------------------------------------------------
    // Standard JUnit Class-specific declarations
    
    private static final Class THIS_CLASS = IReportGeneratorUTestI.class;
    private static final AutoDoc DOC = new AutoDoc( THIS_CLASS );
    
    public IReportGeneratorUTestI( String name, ImplFactory f )
    {
        super( name, IReportGenerator.class, f );
    }

    
    public IReportGenerator createIReportGenerator()
    {
        return (IReportGenerator)createImplObject();
    }


    //-------------------------------------------------------------------------
    // Tests
    
    
    public void testWriteReport1() throws Exception
    {
        IReportGenerator rg = createIReportGenerator();
        
        try
        {
            rg.createReport( null, null );
            fail( "Did not throw IllegalArgumentException." );
        }
        catch (IllegalArgumentException e)
        {
            // test exception
        }
    }
    
    
    public void testWriteReport2() throws Exception
    {
        IReportGenerator rg = createIReportGenerator();
        
        try
        {
            rg.createReport( createIAnalysisModule( "a", "b", "c"), null );
            fail( "Did not throw IllegalArgumentException." );
        }
        catch (IllegalArgumentException e)
        {
            // test exception
        }
    }
    
    
    public void testWriteReport3() throws Exception
    {
        IReportGenerator rg = createIReportGenerator();
        
        try
        {
            rg.createReport( null, createAnalysisModuleData() );
            fail( "Did not throw IllegalArgumentException." );
        }
        catch (IllegalArgumentException e)
        {
            // test exception
        }
    }
    
    
    public void testWriteReport4() throws Exception
    {
        IReportGenerator rg = createIReportGenerator();
        
        rg.createReport( createIAnalysisModule( "a", "b", "c"),
            createAnalysisModuleData() );
    }
    
    
    public void testWriteReport8() throws Exception
    {
        IReportGenerator rg = createIReportGenerator();
        Element el = rg.createReport( createIAnalysisModule( "a", "b", "c" ),
            createAnalysisModuleData() );
        DOC.getLog().info( "Retrieved report: ["+el+"]" );
        assertNotNull(
            "Didn't create an element.",
            el );
    }
    
    
    
    //public void writeReport( IAnalysisModule module, AnalysisModuleData data,
    //        Writer out )
    //        throws IOException;
    
    
    //-------------------------------------------------------------------------
    // Helpers
    
    protected IAnalysisModule createIAnalysisModule( String name, String unit,
            String mime )
    {
        return CCCreatorUtil.createIAnalysisModule( name, unit, mime );
    }
    
    
    /**
     * This is actually an extended test of DirMetaDataReader: even if the
     * DirMetaDataReader instance goes out of scope and its generated
     * DirClassMetaDataReader instances are still in scope, the DirMetaDataIO
     * won't close on us.
     */
    protected AnalysisModuleData createAnalysisModuleData() throws IOException
    {
        IAnalysisModule am = createIAnalysisModule( "a", "b", "text/plain" );
        CCCreatorUtil.SimpleClassLogData[] scld = new
            CCCreatorUtil.SimpleClassLogData[] {
                new CCCreatorUtil.SimpleClassLogData( "a.MyClass-1138",
                    new int[] { 1,2,1 }, new int[] { 11, 2, 13 } ),
            };
        File basedir = CCCreatorUtil.createNewDirectory();
        return CCCreatorUtil.createAnalysisModuleData( am,
            createDirMetaDataReader( basedir ),
            createDirectoryChannelLogReader( basedir, scld ) );
    }
    
    
    protected DirMetaDataReader createDirMetaDataReader( File basedir )
            throws IOException
    {
        return CCCreatorUtil.createDirMetaDataReader( basedir,
            new Class[] { THIS_CLASS, String.class },
            CCCreatorUtil.createAnalysisModules( 2 ) );
    }
    
    
    protected DirectoryChannelLogReader createDirectoryChannelLogReader(
        File basedir, CCCreatorUtil.SimpleClassLogData[] data )
    {
        return CCCreatorUtil.createDirectoryChannelLogReader( basedir, data,
            (short)100 );
    }
    
    
    //-------------------------------------------------------------------------
    // Standard JUnit declarations
    
    
    public static InterfaceTestSuite suite()
    {
        InterfaceTestSuite suite = new InterfaceTestSuite( THIS_CLASS );
        
        return suite;
    }
    
    public static void main( String[] args )
    {
        String[] name = { THIS_CLASS.getName() };
        
        // junit.textui.TestRunner.main( name );
        // junit.swingui.TestRunner.main( name );
        
        junit.textui.TestRunner.main( name );
    }
    
    
    /**
     * 
     * @exception Exception thrown under any exceptional condition.
     */
    protected void setUp() throws Exception
    {
        super.setUp();
        
        // set ourself up
    }
    
    
    /**
     * 
     * @exception Exception thrown under any exceptional condition.
     */
    protected void tearDown() throws Exception
    {
        // tear ourself down
        
        
        super.tearDown();
    }
}

