/*
 * @(#)AutoDocITImplUTest.java
 *
 * Copyright (C) 2002-2003 Matt Albrecht
 * groboclown@users.sourceforge.net
 * http://groboutils.sourceforge.net
 *
 *  Permission is hereby granted, free of charge, to any person obtaining a
 *  copy of this software and associated documentation files (the "Software"),
 *  to deal in the Software without restriction, including without limitation
 *  the rights to use, copy, modify, merge, publish, distribute, sublicense,
 *  and/or sell copies of the Software, and to permit persons to whom the
 *  Software is furnished to do so, subject to the following conditions:
 *
 *  The above copyright notice and this permission notice shall be included in
 *  all copies or substantial portions of the Software.
 *
 *  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 *  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 *  THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 *  FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 *  DEALINGS IN THE SOFTWARE.
 */

package net.sourceforge.groboutils.pmti.v1.autodoc.v1;

import java.util.Vector;
import java.util.Hashtable;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import net.sourceforge.groboutils.autodoc.v1.AutoDocITUTestI;
import net.sourceforge.groboutils.autodoc.v1.testserver.*;
import net.sourceforge.groboutils.junit.v1.iftc.*;
import junit.framework.AssertionFailedError;


/**
 * Tests the AutoDocITImpl class.
 *
 * @author    Matt Albrecht <a href="mailto:groboclown@users.sourceforge.net">groboclown@users.sourceforge.net</a>
 * @version   $Date: 2003/05/29 13:04:45 $
 * @since     March 5, 2002
 */
public class AutoDocITImplUTest extends TestCase
{
    //-------------------------------------------------------------------------
    // Standard JUnit Class-specific declarations
    
    private static final Class THIS_CLASS = AutoDocITImplUTest.class;
    //private static final IJUnitDocumentor LOG = (new JUnitLog(THIS_CLASS)).getDocumentor();
    
    public AutoDocITImplUTest( String name )
    {
        super( name );
    }

    
    //-------------------------------------------------------------------------
    // setup
    
    /**
     * 
     * @exception Exception thrown under any exceptional condition.
     */
    protected void setUp() throws Exception
    {
        super.setUp();
        
        // set ourself up
    }


    //-------------------------------------------------------------------------
    // Tests
    
    public class MyMonitor implements Monitor
    {
        public Vector addedTests = new Vector();
        public Hashtable testData = new Hashtable();
        public Vector sentTests = new Vector();
        
        public void addTestData( TestInfo info )
        {
            addedTests.addElement( info );
        }
    
    
        public TestData getTestData( TestInfo info )
        {
            return (TestData)testData.get( info );
        }
        
    
        public void sendTestData( TestInfo info )
        {
            sentTests.addElement( info );
        }
    }
    
    public class MyMonitorFinder implements MonitorFinder
    {
        private Monitor m;
        public MyMonitorFinder( Monitor m )
        {
            this.m = m;
        }
        
        public Monitor getMonitor()
        {
            return m; 
        }
    }
    
    
    
    

    public void testSendTestIssue1()
    {
        MyMonitor mon = new MyMonitor();
        MyMonitorFinder mf = new MyMonitorFinder( mon );
        DefaultTestInfo ti = new DefaultTestInfo( "a", "b" );
        DefaultTestData td = new DefaultTestData( ti );
        mon.testData.put( ti, td );
        
        AutoDocITImpl it = new AutoDocITImpl( THIS_CLASS, mf );
        try
        {
            it.sendTestIssue( ti, "" );
            fail("did not throw IllegalStateException");
        }
        catch (IllegalStateException iae)
        {
            // test exception?
        }
    }
    

    public void testSendTestIssue2()
    {
        MyMonitor mon = new MyMonitor();
        MyMonitorFinder mf = new MyMonitorFinder( mon );
        DefaultTestInfo ti = new DefaultTestInfo( "a", "b" );
        ITFTestData td = new ITFTestData( ti );
        mon.testData.put( ti, td );
        
        AutoDocITImpl it = new AutoDocITImpl( THIS_CLASS, mf );
        it.sendTestIssue( ti, "a" );

        String[] issues = td.getIssues();
        assertNotNull(
            "null issue set",
            issues );
        assertEquals(
            "incorrect number of issues registered.",
            issues.length,
            1 );
        assertEquals(
            "incorrect registration of issue.",
            issues[0],
            "a" );
    }
    
    
    
    //-------------------------------------------------------------------------
    // Helpers
    
    
    //-------------------------------------------------------------------------
    // Standard JUnit declarations
    
    
    public static Test suite()
    {
        InterfaceTestSuite suite = AutoDocITUTestI.suite();
        suite.addTestSuite( THIS_CLASS );
        suite.addFactory( new CxFactory( "A" ) {
            public Object createImplObject() {
                return new AutoDocITImpl( THIS_CLASS );
            }
        } );
        
        return suite;
    }
    
    public static void main( String[] args )
    {
        String[] name = { THIS_CLASS.getName() };
        
        // junit.textui.TestRunner.main( name );
        // junit.swingui.TestRunner.main( name );
        
        junit.textui.TestRunner.main( name );
    }
    
    
    /**
     * 
     * @exception Exception thrown under any exceptional condition.
     */
    protected void tearDown() throws Exception
    {
        // tear ourself down
        
        
        super.tearDown();
    }
}

