package org.jboss.cache.notifications.annotation;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * This annotation should be used on methods that need to be notified when a cache is started.
 * <p/>
 * Methods annotated with this annotation should accept a single
 * parameter, a {@link org.jboss.cache.notifications.event.CacheStartedEvent} otherwise a {@link org.jboss.cache.notifications.IncorrectCacheListenerException}
 * will be thrown when registering your listener.
 *
 * @author <a href="mailto:manik@jboss.org">Manik Surtani</a>
 * @see CacheListener
 * @since 2.0.0
 */
@Retention(RetentionPolicy.RUNTIME)
@Target(ElementType.METHOD)
public @interface CacheStarted
{
}
