/*
 * Decompiled with CFR 0.152.
 */
package org.boehn.kmlframework.todo;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import org.boehn.kmlframework.coordinates.CartesianCoordinate;
import org.boehn.kmlframework.coordinates.EarthCoordinate;
import org.boehn.kmlframework.coordinates.TimeAndPlace;
import org.boehn.kmlframework.kml.Kml;
import org.boehn.kmlframework.kml.KmlException;
import org.boehn.kmlframework.todo.Button;
import org.boehn.kmlframework.todo.MapObjectClass;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapObject {
    private String name;
    private String description;
    private EarthCoordinate location;
    private MapObjectClass mapObjectClass;
    private List<Button> buttons;
    private List<TimeAndPlace> movements;
    private String snippet;
    private Boolean visibility;
    private Double rotation;
    private CartesianCoordinate localReferenceCoordinate;
    private CartesianCoordinate scale;

    public MapObject() {
    }

    public MapObject(String name) {
        this.name = name;
    }

    public MapObject(MapObjectClass mapObjectClass) {
        this.mapObjectClass = mapObjectClass;
    }

    public MapObject(String name, MapObjectClass mapObjectClass) {
        this.name = name;
        this.mapObjectClass = mapObjectClass;
    }

    public MapObjectClass getMapObjectClass() {
        return this.mapObjectClass;
    }

    public void setMapObjectClass(MapObjectClass mapObjectClass) {
        this.mapObjectClass = mapObjectClass;
    }

    public CartesianCoordinate getLocalReferenceCoordinate() {
        return this.localReferenceCoordinate;
    }

    public void setLocalReferenceCoordinate(CartesianCoordinate localReferenceCoordinate) {
        this.localReferenceCoordinate = localReferenceCoordinate;
    }

    public Double getRotation() {
        return this.rotation;
    }

    public void setRotation(Double rotation) {
        this.rotation = rotation;
    }

    public CartesianCoordinate getScale() {
        return this.scale;
    }

    public void setScale(CartesianCoordinate scale) {
        this.scale = scale;
    }

    public Boolean getVisibility() {
        return this.visibility;
    }

    public void setVisibility(Boolean visibility) {
        this.visibility = visibility;
    }

    public void setButtons(List<Button> buttons) {
        this.buttons = buttons;
    }

    public void addButton(Button button) {
        if (this.buttons == null) {
            this.buttons = new ArrayList<Button>();
        }
        this.buttons.add(button);
    }

    public void addButtons(List<Button> buttons) {
        if (this.buttons == null) {
            this.buttons = buttons;
        } else {
            this.buttons.addAll(buttons);
        }
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescriptionTextWithButtons(Kml model) {
        StringBuffer result = new StringBuffer();
        if (this.buttons != null) {
            for (Button button : this.buttons) {
                result.append(String.valueOf(button.toHtml(model)) + "<br />");
            }
        }
        if (this.description != null) {
            result.append(this.description);
        }
        return result.length() == 0 ? null : result.toString();
    }

    public EarthCoordinate getLocation() {
        return this.location;
    }

    public void setLocation(EarthCoordinate earthCoordinate) {
        this.location = earthCoordinate;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getSnippet() {
        return this.snippet;
    }

    public void setSnippet(String snippet) {
        this.snippet = snippet;
    }

    public void addKml(Kml kmlDocument, PrintWriter printWriter) {
        printWriter.println("<Placemark>");
        if (this.name != null) {
            printWriter.println("<name>" + this.name + "</name>");
        }
        printWriter.println("</Placemark>");
    }

    public void addKml(Element parentElement, Kml model, Document xmlDocument) throws KmlException {
        String descriptionText;
        Element placemarkElement = xmlDocument.createElement("Placemark");
        if (this.name != null) {
            Element nameElement = xmlDocument.createElement("name");
            nameElement.appendChild(xmlDocument.createTextNode(this.name));
            placemarkElement.appendChild(nameElement);
        }
        if (this.snippet != null) {
            Element snippetElement = xmlDocument.createElement("Snippet");
            snippetElement.appendChild(xmlDocument.createTextNode(this.snippet));
            placemarkElement.appendChild(snippetElement);
        }
        if ((descriptionText = this.getDescriptionTextWithButtons(model)) != null) {
            Element descriptionElement = xmlDocument.createElement("description");
            descriptionElement.appendChild(xmlDocument.createCDATASection(descriptionText));
            placemarkElement.appendChild(descriptionElement);
        }
        if (this.mapObjectClass != null) {
            this.mapObjectClass.addKml(this, parentElement, model, xmlDocument, this.location, this.rotation, this.localReferenceCoordinate, this.scale, this.name);
        }
        if (this.visibility != null) {
            Element visibilityElement = xmlDocument.createElement("visibility");
            visibilityElement.appendChild(xmlDocument.createTextNode(this.visibility != false ? "1" : "0"));
            placemarkElement.appendChild(visibilityElement);
        }
        parentElement.appendChild(placemarkElement);
    }

    public List<TimeAndPlace> getMovements() {
        return this.movements;
    }

    public void setMovements(List<TimeAndPlace> movements) {
        this.movements = movements;
    }

    public void addMovement(TimeAndPlace movement) {
        if (this.movements == null) {
            this.movements = new ArrayList<TimeAndPlace>();
        }
        this.movements.add(movement);
    }

    public String toString() {
        StringBuffer text = new StringBuffer("MapObject:\n");
        text.append("   name: '" + this.name + "'\n");
        text.append("   description: '" + this.description + "'\n");
        text.append("   rotation: " + this.rotation + "\n");
        text.append("   scale: " + this.scale + "\n");
        text.append("   localReferenceCoordinate: " + this.localReferenceCoordinate + "\n");
        text.append("   location: " + this.location + "\n");
        text.append("   buttons: " + this.buttons + "\n");
        text.append("   movements: " + this.movements + "\n");
        text.append("   mapObjectClass: " + this.mapObjectClass + "\n");
        return text.toString();
    }
}

