# Jasmine Core 2.1.0 Release Notes

## Summary

This is the release of Jasmine 2.1.

## Features

- Support for focused specs via `fit` and `fdescribe`
- Support for `beforeAll` and `afterAll`
- Support for an explicit `fail` function, both in synchronous and asynchronous specs
- Allow custom timeout for `beforeEach`, `afterEach`, `beforeAll`, `afterAll` and `it`
- Spies now track return values
- Specs can now specify their own timeouts
- Testing in Node.js via the official Jasmine Node Module
- Spec results now have `suiteResults` method that behaves similarly to to `specResults`
- HtmlReporter shows error alerts for afterAllExceptions

## Bugs

- CI now works for IE8 (this was releated to `ConsoleReporter` below)
- Detect global object properly when getting the jasmine require obj
  - Fixes Issue #[569][issue_569]  - [Tracker Story #73684570](http://www.pivotaltracker.com/story/73684570)

## Deprecations

### `ConsoleReporter` as part of Jasmine core

The Console Reporter exists nearly entirely for the old manner of running Jasmine's own specs in node.js. As we are now supporting node.js officially, this reporter code no longer needs to be in this repo and instead will be in the Jasmine npm.

For now you will see a deprecation message. It will be removed entirely in Jasmine 3.0.

## Documentation

- Release Notes from previous releases now live at [Jasmine's GitHub release page][releases]. See Tracker Story #[54582902][tracker_1]
- Better instructions for releasing new documentation

[releases]: https://github.com/pivotal/jasmine/releases
[tracker_1]: http://www.pivotaltracker.com/story/54582902


## Pull Requests and Issues

- Simplification of HTMLtags in SpecRunner.html
    - Merges #[700][issue_700] from @tkrotoff
- `toContain` works with array-like objects (Arguments, HTMLCollections, etc)
    - Merges #[699][issue_699] from @charleshansen
- Fixed isPendingSpecException test title
    - Merges #[691][issue_691] from @ertrzyiks
- Fixed an issue with example code in the npm
    - Merges #[686][issue_686] from @akoptsov
- When the Jasmine clock is installed and date is mocked, `new Date() instanceof Date` should equal `true` Issue #[678][issue_678] & Issue #[679][issue_679] from @chernetsov
- Support for an explicit `fail` function, both in synchronous and asynchronous specs
    - Fixes Issue #[567][issue_567], Issue #[568][issue_568], and Issue #[563][issue_563]
- Allow custom timeout for `beforeEach`, `afterEach`, `beforeAll`, `afterAll` and `it`
    - Fixes Issue #[483][issue_483] - specs can now specify their own timeouts
- Spies can track return values
    - Fixes Issue #[660][issue_660], Merged Issue #[669][issue_669] from @mkhanal
- Interval handlers can now clear their interval
    - Fixes Issue #[655][issue_655] Merged Issue #[658][issue_658] from @tgirardi
- Updated to the latest `json2.js`
    - Merges #[616][issue_616] from @apaladox2015

------

_Release Notes generated with [Anchorman](http://github.com/infews/anchorman)_

[issue_569]: http://github.com/pivotal/jasmine/issues/569
[issue_700]: http://github.com/pivotal/jasmine/issues/700
[issue_699]: http://github.com/pivotal/jasmine/issues/699
[issue_691]: http://github.com/pivotal/jasmine/issues/691
[issue_678]: http://github.com/pivotal/jasmine/issues/678
[issue_679]: http://github.com/pivotal/jasmine/issues/679
[issue_567]: http://github.com/pivotal/jasmine/issues/567
[issue_568]: http://github.com/pivotal/jasmine/issues/568
[issue_563]: http://github.com/pivotal/jasmine/issues/563
[issue_483]: http://github.com/pivotal/jasmine/issues/483
[issue_660]: http://github.com/pivotal/jasmine/issues/660
[issue_669]: http://github.com/pivotal/jasmine/issues/669
[issue_655]: http://github.com/pivotal/jasmine/issues/655
[issue_658]: http://github.com/pivotal/jasmine/issues/658
[issue_616]: http://github.com/pivotal/jasmine/issues/616
[issue_686]: http://github.com/pivotal/jasmine/issues/686
